@extends('layouts.master')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">

    <div class="card">
        <h5 class="card-header" style="color:black;">Cameras List</h5>
        <div class="table-responsive text-nowrap">
            <table class="table">
                <thead>
                    <tr class="text-nowrap">
                        <th>#</th>
                        <th>Camera Name</th>
                        <th>Streaming URl</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @if ($cameras)
                    @foreach ($cameras as $index => $list)
                    <tr>
                        <th scope="row">{{ ++$index }}</th>
                        <td>{{ $list['cameraname'] }}</td>
                        <td>{{ $list['stream_url'] }}</td>
                        <td>
                            @if ($list['status'] == 1)
                            <span class="badge bg-success ">Active</span>
                            @else
                            <span class="badge bg-danger badge-sm">Disconnected</span>
                            @endif
                        </td>

                        <td><a href="{{ route('camera.details', $list['_id']) }}" class="btn btn-primary  btn-sm">Open
                                Camera</a>


                            <a href="{{ route('camera.details', $list['_id']) }}" class="btn btn-info  btn-sm">Edit </a>


                            <a href="{{ route('camera.details', $list['_id']) }}" class="btn btn-danger  btn-sm">Delete
                            </a>
                        </td>
                    </tr>
                    @endforeach
                    @endif

                </tbody>
            </table>
        </div>

    </div>


    <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
        {{-- <a href="" class="btn btn-secondary" style="width: 150px;margin-right: 50px;">Back</a> --}}
        {{-- <a href="" class="btn btn-primary" style="width: 150px;">Next</a> --}}
    </div>


</div>
</div>
</div>


@endSection